unit Sdimain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, ImgList, StdActns,
  ActnList, ToolWin;

type
  TSDIAppForm = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ToolBar1: TToolBar;
    ToolButton9: TToolButton;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ActionList1: TActionList;
    FileNew1: TAction;
    FileOpen1: TAction;
    FileSave1: TAction;
    FileSaveAs1: TAction;
    FileExit1: TAction;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    HelpAbout1: TAction;
    StatusBar: TStatusBar;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    Help1: TMenuItem;
    HelpAboutItem: TMenuItem;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    FindReplace1: TMenuItem;
    Find1: TMenuItem;
    Replace1: TMenuItem;
    RichEdit1: TRichEdit;
    procedure FileNew1Execute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SDIAppForm: TSDIAppForm;

implementation

uses About;

{$R *.DFM}

procedure TSDIAppForm.FileNew1Execute(Sender: TObject);
begin
  { Do nothing }
  RichEdit1.Clear;
end;

procedure TSDIAppForm.FileOpen1Execute(Sender: TObject);
begin
  OpenDialog.FileName:='*.txt';
  if  OpenDialog.Execute then
  begin
    RichEdit1.Clear;
    RichEdit1.Lines.LoadFromFile(OpenDialog.FileName);
  end;
end;

procedure TSDIAppForm.FileSave1Execute(Sender: TObject);
begin
  SaveDialog.FileName:='*.txt';
  if SaveDialog.Execute then
    RIchEdit1.Lines.SaveToFile(SaveDialog.FileName);
end;

procedure TSDIAppForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TSDIAppForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSDIAppForm.Replace1Click(Sender: TObject);
begin
   ReplaceDialog1.Position := Point(RichEdit1.Left + RichEdit1.Width, RichEdit1.Top);
   ReplaceDialog1.Execute;
end;

procedure TSDIAppForm.FindDialog1Find(Sender: TObject);
var
   Kezd,Veg : integer;
   Talalt   : LongInt;
begin
     Talalt:=-1;
     With RichEdit1 do
     begin
       RichEdit1.SelLength := 0;
       Kezd := 0;
       Veg := Length( Text) - Kezd;
       Talalt := FindText(FindDialog1.FindText, Kezd,Veg, [stMatchCase]);
       if Talalt <> -1 then
       begin
         SetFocus;
         SelStart := Talalt;
         SelLength := Length(FindDialog1.FindText);
       end;
     end;
end;

procedure TSDIAppForm.Find1Click(Sender: TObject);
begin
   FindDialog1.Position := Point(RichEdit1.Left + RichEdit1.Width, RichEdit1.Top);
   FindDialog1.Execute;
end;

procedure TSDIAppForm.ReplaceDialog1Replace(Sender: TObject);
var
   Talal : integer;
begin
   with TReplaceDialog(Sender) do
   begin
     Talal := Pos(FindText, RichEdit1.Lines.Text);
     if Talal > 0 then
     begin
        RichEdit1.SelStart := Talal -1;
        RichEdit1.SelLength := Length(FindText);
        RichEdit1.SelText := ReplaceText;
     end
     else
       ShowMessage(FindText + ' nem tallt mr!');
   end;
end;

end.
